/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.wbem.cim.CIMException;
import javax.wbem.client.Debug;

public class ClientProperties {
    private static final String PROP_DEFAULT_FILE = "javax.wbem.client.WbemDefaults";
    private static final String PROP_EXTEND_FILE = "WbemClient";
    private static Properties props = null;

    private ClientProperties() {
    }

    public static synchronized String getProperty(String name) throws CIMException {
        if (props == null) {
            ClientProperties.initProperties();
        }
        return props.getProperty(name);
    }

    public static List getPropertyList(String name) throws CIMException {
        ArrayList<String> list = new ArrayList<String>();
        ClientProperties.initProperties();
        String prefix = name.concat(".");
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String val;
            String key = (String)en.nextElement();
            if (!key.startsWith(prefix) || (val = props.getProperty(key)) == null) continue;
            list.add(val);
        }
        return list;
    }

    private static void initProperties() throws CIMException {
        if (props == null) {
            props = new Properties();
            try {
                ClientProperties.loadProperties(PROP_DEFAULT_FILE);
            }
            catch (Exception ex) {
                Debug.trace1("Error loading WbemDefaults properties.");
                throw new CIMException("CIM_ERR_FAILED", PROP_DEFAULT_FILE);
            }
            try {
                ClientProperties.loadProperties(PROP_EXTEND_FILE);
            }
            catch (MissingResourceException ex) {
                Debug.trace1("Couldn't loading extended properties: WbemClient");
            }
            if (Debug.isOn()) {
                Debug.trace3("Client configuration properties:");
                Enumeration<?> en = props.propertyNames();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    String val = String.valueOf(props.getProperty(key));
                    Debug.trace3("    " + key + " \t" + val);
                }
            }
        }
    }

    private static void loadProperties(String bundle) throws CIMException {
        PropertyResourceBundle prb = (PropertyResourceBundle)ResourceBundle.getBundle(bundle, new Locale("", ""));
        if (prb != null) {
            Enumeration<String> en = prb.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                if (key == null) continue;
                try {
                    String val = prb.getString(key);
                    props.setProperty(key, val);
                }
                catch (Exception ex) {}
            }
        }
    }
}

