/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Debug {
    private static final boolean ON = true;
    private static final String TRACE_DIR = "/var/tmp";
    private static final String TRACE_STDOUT_NAME = "stdout";
    private static final String TRACE_STDERR_NAME = "stderr";
    private static final int TRACE_OFF = 0;
    private static final int TRACE_STDOUT = 1;
    private static final int TRACE_STDERR = 2;
    private static final int TRACE_FILE = 3;
    private static final int TRACE_RETRY = 5;
    private static boolean trace_init = false;
    private static int trace_level = 0;
    private static boolean trace_time = false;
    private static boolean trace_method = false;
    private static boolean trace_thread = false;
    private static int trace_out = 2;
    private static FileWriter trace_fw;
    private static BufferedWriter trace_bw;
    private static PrintWriter trace_pw;

    public static final void traceOpen(String level, String filename) {
        Debug.openTrace(level, filename);
    }

    public static final boolean isOn() {
        return trace_level > 0;
    }

    public static final void trace1(String message) {
        if (trace_level > 0) {
            Debug.writeTrace(message);
        }
    }

    public static final void trace1(String message, Throwable ex) {
        if (trace_level > 0) {
            Debug.writeTrace(message);
            if (ex != null) {
                Debug.writeStackTrace(ex);
            }
        }
    }

    public static final void trace2(String message) {
        if (trace_level > 1) {
            Debug.writeTrace(message);
        }
    }

    public static final void trace2(String message, Throwable ex) {
        if (trace_level > 1) {
            Debug.writeTrace(message);
            if (ex != null) {
                Debug.writeStackTrace(ex);
            }
        }
    }

    public static final void trace3(String message) {
        if (trace_level > 2) {
            Debug.writeTrace(message);
        }
    }

    public static final void trace3(String message, Throwable ex) {
        if (trace_level > 2) {
            Debug.writeTrace(message);
            if (ex != null) {
                Debug.writeStackTrace(ex);
            }
        }
    }

    private static void openTrace(String level, String filename) {
        String trace_file = null;
        String trace_sufx = null;
        if (trace_init) {
            return;
        }
        trace_level = 0;
        trace_time = false;
        trace_method = false;
        trace_thread = false;
        if (level != null) {
            Integer ix;
            try {
                ix = new Integer(level.substring(0, 1));
            }
            catch (Exception ex) {
                ix = new Integer(0);
            }
            trace_level = ix;
            if (level.indexOf(116) > 0) {
                trace_time = true;
            }
            if (level.indexOf(109) > 0) {
                trace_method = true;
            }
            if (level.indexOf(112) > 0) {
                trace_thread = true;
            }
        }
        if (trace_level == 0) {
            return;
        }
        if (filename != null && filename.trim().length() != 0) {
            if (filename.equals(TRACE_STDOUT_NAME)) {
                trace_out = 1;
            } else if (filename.equals(TRACE_STDERR_NAME)) {
                trace_out = 2;
            } else {
                trace_out = 3;
                trace_file = filename.trim();
            }
        } else {
            trace_out = 2;
        }
        if (trace_out == 3 && trace_level > 0) {
            int i;
            if (trace_file.indexOf(File.separatorChar) < 0) {
                trace_file = Debug.getLogDir() + File.separator + trace_file;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("MMdd_HHmm");
            trace_sufx = "_" + sdf.format(new Date());
            String name = trace_file = trace_file + trace_sufx;
            for (i = 1; i < 5; ++i) {
                try {
                    File fd1 = new File(name);
                    if (!fd1.exists()) break;
                    name = trace_file + "_" + i;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (i < 5) {
                try {
                    trace_fw = new FileWriter(name);
                    trace_bw = new BufferedWriter(trace_fw);
                    trace_pw = new PrintWriter((Writer)trace_bw, true);
                }
                catch (Exception ex) {
                    trace_level = 0;
                }
            } else {
                trace_level = 0;
            }
        }
        trace_init = true;
    }

    private static void writeStackTrace(Throwable ex) {
        try {
            if (trace_out == 3) {
                ex.printStackTrace(trace_pw);
            } else if (trace_out == 1) {
                ex.printStackTrace(System.out);
            } else if (trace_out == 2) {
                ex.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getLogDir() {
        return TRACE_DIR;
    }

    private static String getClassMethod() {
        String clm = null;
        try {
            InputStream is = Debug.getStackStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            br.readLine();
            br.readLine();
            br.readLine();
            br.readLine();
            br.readLine();
            String line = br.readLine();
            clm = Debug.getCaller(line);
            br.close();
        }
        catch (Exception ex) {
            clm = "??:??";
        }
        return clm;
    }

    private static synchronized void writeTrace(String msg) {
        String trace_msg = "";
        if (trace_time) {
            Time tim = new Time(System.currentTimeMillis());
            trace_msg = tim.toString() + " | ";
        }
        if (trace_thread) {
            Thread th = Thread.currentThread();
            trace_msg = trace_msg + th.getName() + " | ";
        }
        if (trace_method) {
            trace_msg = trace_msg + Debug.getClassMethod() + " | ";
        }
        trace_msg = trace_msg + msg;
        try {
            if (trace_out == 3) {
                trace_pw.println(trace_msg);
            } else if (trace_out == 1) {
                System.out.println(trace_msg);
            } else if (trace_out == 2) {
                System.err.println(trace_msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static InputStream getStackStream() {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            PrintWriter pw = new PrintWriter(os);
            new Exception().printStackTrace(pw);
            pw.close();
            is = new ByteArrayInputStream(os.toByteArray());
        }
        catch (Exception ex) {
            is = null;
        }
        return is;
    }

    private static String getCaller(String line) {
        String str = line;
        int i = line.indexOf(40);
        if (i > 0) {
            str = line.substring(0, i);
        }
        if ((i = str.indexOf("at")) > 0) {
            str = str.substring(i + 3);
        }
        if ((i = str.lastIndexOf(46)) > 0) {
            String mth = str.substring(i + 1);
            String cls = (i = (str = str.substring(0, i)).lastIndexOf(46)) > 0 ? str.substring(i + 1) : str;
            str = cls + ":" + mth;
        }
        return str;
    }
}

