/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.query;

import java.io.ByteArrayInputStream;
import javax.wbem.query.FromExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLExp;
import javax.wbem.query.WQLParser;

public class SelectExp
extends WQLExp {
    private SelectList attList;
    private QueryExp whereClause;
    private FromExp fromExp;

    public SelectExp(String query) {
        WQLParser parser = new WQLParser(new ByteArrayInputStream(query.getBytes()));
        SelectExp exp = null;
        try {
            exp = (SelectExp)parser.querySpecification();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
        this.attList = exp.attList;
        this.whereClause = exp.whereClause;
        this.fromExp = exp.fromExp;
    }

    public SelectExp(SelectList attList, FromExp fromExp) {
        this.attList = attList;
        this.fromExp = fromExp;
    }

    public SelectExp(SelectList attList, FromExp fromExp, QueryExp whereClause) {
        this.attList = attList;
        this.fromExp = fromExp;
        this.whereClause = whereClause;
    }

    public SelectExp() {
    }

    public SelectList getSelectList() {
        return this.attList;
    }

    public QueryExp getWhereClause() {
        return this.whereClause;
    }

    public FromExp getFromClause() {
        return this.fromExp;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("select ").append(this.attList).append(" from ").append(this.fromExp);
        if (this.whereClause != null) {
            s.append(" where ").append(this.whereClause);
        }
        return s.toString();
    }
}

