/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding;

import com.jgoodies.binding.beans.BeanAdapter;
import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PresentationModel
extends Model {
    public static final String PROPERTYNAME_BEFORE_BEAN = "beforeBean";
    public static final String PROPERTYNAME_BEAN = "bean";
    public static final String PROPERTYNAME_AFTER_BEAN = "afterBean";
    public static final String PROPERTYNAME_TRIGGERCHANNEL = "triggerChannel";
    public static final String PROPERTYNAME_BUFFERING = "buffering";
    public static final String PROPERTYNAME_CHANGED = "changed";
    private final ValueModel beanChannel;
    private final BeanAdapter beanAdapter;
    private ValueModel triggerChannel;
    private final Map wrappedBuffers;
    private final PropertyChangeListener bufferingUpdateHandler;
    private boolean buffering = false;
    private final PropertyChangeListener changedUpdateHandler;
    private boolean changed = false;

    public PresentationModel(Object bean) {
        this(new ValueHolder(bean, true));
    }

    public PresentationModel(Object bean, ValueModel triggerChannel) {
        this(new ValueHolder(bean, true), triggerChannel);
    }

    public PresentationModel(ValueModel beanChannel) {
        this(beanChannel, (ValueModel)new Trigger());
    }

    public PresentationModel(ValueModel beanChannel, ValueModel triggerChannel) {
        this.beanChannel = beanChannel;
        this.beanAdapter = new BeanAdapter(beanChannel, true);
        this.triggerChannel = triggerChannel;
        this.wrappedBuffers = new HashMap();
        this.bufferingUpdateHandler = new BufferingStateHandler();
        this.changed = false;
        this.changedUpdateHandler = new UpdateHandler();
        this.beanAdapter.addPropertyChangeListener(new BeanChangeHandler());
        this.observeChanged(this.beanAdapter, PROPERTYNAME_CHANGED);
    }

    public final ValueModel getBeanChannel() {
        return this.beanChannel;
    }

    public final Object getBean() {
        return this.getBeanChannel().getValue();
    }

    public final void setBean(Object newBean) {
        this.getBeanChannel().setValue(newBean);
    }

    public void beforeBeanChange(Object oldBean, Object newBean) {
        this.firePropertyChange(PROPERTYNAME_BEFORE_BEAN, oldBean, newBean, true);
    }

    public void afterBeanChange(Object oldBean, Object newBean) {
        this.setChanged(false);
        this.firePropertyChange(PROPERTYNAME_AFTER_BEAN, oldBean, newBean, true);
    }

    public final AbstractValueModel getModel(String propertyName) {
        return this.beanAdapter.getValueModel(propertyName);
    }

    public final ValueModel getModel(String propertyName, String getterName, String setterName) {
        return this.beanAdapter.getValueModel(propertyName, getterName, setterName);
    }

    public final BufferedValueModel getBufferedModel(String propertyName) {
        return this.getBufferedModel(propertyName, null, null);
    }

    public final BufferedValueModel getBufferedModel(String propertyName, String getterName, String setterName) {
        WrappedBuffer wrappedBuffer = (WrappedBuffer)this.wrappedBuffers.get(propertyName);
        if (wrappedBuffer == null) {
            wrappedBuffer = new WrappedBuffer(this.buffer(this.getModel(propertyName, getterName, setterName)), getterName, setterName);
            this.wrappedBuffers.put(propertyName, wrappedBuffer);
        } else if (!this.equals(getterName, wrappedBuffer.getterName) || !this.equals(setterName, wrappedBuffer.setterName)) {
            throw new IllegalArgumentException("You must not invoke this method twice with different getter and/or setter names.");
        }
        return wrappedBuffer.buffer;
    }

    private BufferedValueModel buffer(ValueModel valueModel) {
        BufferedValueModel bufferedModel = new BufferedValueModel(valueModel, this.getTriggerChannel());
        bufferedModel.addPropertyChangeListener(PROPERTYNAME_BUFFERING, this.bufferingUpdateHandler);
        return bufferedModel;
    }

    public final ValueModel getTriggerChannel() {
        return this.triggerChannel;
    }

    public final void setTriggerChannel(ValueModel newTriggerChannel) {
        if (newTriggerChannel == null) {
            throw new NullPointerException("The trigger channel must not be null.");
        }
        ValueModel oldTriggerChannel = this.getTriggerChannel();
        this.triggerChannel = newTriggerChannel;
        Iterator iter = this.wrappedBuffers.values().iterator();
        while (iter.hasNext()) {
            WrappedBuffer wrappedBuffer = (WrappedBuffer)iter.next();
            wrappedBuffer.buffer.setTriggerChannel(this.triggerChannel);
        }
        this.firePropertyChange(PROPERTYNAME_TRIGGERCHANNEL, oldTriggerChannel, newTriggerChannel);
    }

    public final void triggerCommit() {
        if (Boolean.TRUE.equals(this.getTriggerChannel().getValue())) {
            this.getTriggerChannel().setValue(null);
        }
        this.getTriggerChannel().setValue(Boolean.TRUE);
    }

    public final void triggerFlush() {
        if (Boolean.FALSE.equals(this.getTriggerChannel().getValue())) {
            this.getTriggerChannel().setValue(null);
        }
        this.getTriggerChannel().setValue(Boolean.FALSE);
    }

    public final boolean isBuffering() {
        return this.buffering;
    }

    private void setBuffering(boolean newValue) {
        boolean oldValue = this.isBuffering();
        this.buffering = newValue;
        this.firePropertyChange(PROPERTYNAME_BUFFERING, oldValue, newValue);
    }

    private void updateBufferingState(boolean latestBufferingStateChange) {
        if (this.buffering == latestBufferingStateChange) {
            return;
        }
        boolean nowBuffering = false;
        Iterator it = this.wrappedBuffers.values().iterator();
        while (it.hasNext()) {
            WrappedBuffer wrappedBuffer = (WrappedBuffer)it.next();
            BufferedValueModel model = wrappedBuffer.buffer;
            boolean bl = nowBuffering = nowBuffering || model.isBuffering();
            if (this.buffering || !nowBuffering) continue;
            this.setBuffering(true);
            return;
        }
        this.setBuffering(nowBuffering);
    }

    public final boolean isChanged() {
        return this.changed;
    }

    public void resetChanged() {
        this.setChanged(false);
        this.beanAdapter.resetChanged();
    }

    protected void setChanged(boolean newValue) {
        boolean oldValue = this.isChanged();
        this.changed = newValue;
        this.firePropertyChange(PROPERTYNAME_CHANGED, oldValue, newValue);
    }

    public void observeChanged(Object bean, String propertyName) {
        if (bean == null) {
            throw new NullPointerException("The bean must not be null.");
        }
        if (propertyName == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        BeanUtils.addPropertyChangeListener(bean, propertyName, this.changedUpdateHandler);
    }

    public void observeChanged(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The ValueModel must not be null.");
        }
        valueModel.addValueChangeListener(this.changedUpdateHandler);
    }

    public void retractInterestFor(Object bean, String propertyName) {
        if (bean == null) {
            throw new NullPointerException("The bean must not be null.");
        }
        if (propertyName == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        BeanUtils.removePropertyChangeListener(bean, propertyName, this.changedUpdateHandler);
    }

    public void retractInterestFor(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The ValueModel must not be null.");
        }
        valueModel.removeValueChangeListener(this.changedUpdateHandler);
    }

    public synchronized void addBeanPropertyChangeListener(PropertyChangeListener listener) {
        this.beanAdapter.addBeanPropertyChangeListener(listener);
    }

    public synchronized void removeBeanPropertyChangeListener(PropertyChangeListener listener) {
        this.beanAdapter.removeBeanPropertyChangeListener(listener);
    }

    public synchronized void addBeanPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.beanAdapter.addBeanPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removeBeanPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.beanAdapter.removeBeanPropertyChangeListener(propertyName, listener);
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners() {
        return this.beanAdapter.getBeanPropertyChangeListeners();
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners(String propertyName) {
        return this.beanAdapter.getBeanPropertyChangeListeners(propertyName);
    }

    private class UpdateHandler
    implements PropertyChangeListener {
        private UpdateHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (!PresentationModel.PROPERTYNAME_CHANGED.equals(propertyName) || ((Boolean)evt.getNewValue()).booleanValue()) {
                PresentationModel.this.setChanged(true);
            }
        }
    }

    private class BufferingStateHandler
    implements PropertyChangeListener {
        private BufferingStateHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            PresentationModel.this.updateBufferingState((Boolean)evt.getNewValue());
        }
    }

    private class BeanChangeHandler
    implements PropertyChangeListener {
        private BeanChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object oldBean = evt.getOldValue();
            Object newBean = evt.getNewValue();
            String propertyName = evt.getPropertyName();
            if (PresentationModel.PROPERTYNAME_BEFORE_BEAN.equals(propertyName)) {
                PresentationModel.this.beforeBeanChange(oldBean, newBean);
            } else if (PresentationModel.PROPERTYNAME_BEAN.equals(propertyName)) {
                PresentationModel.this.firePropertyChange(PresentationModel.PROPERTYNAME_BEAN, oldBean, newBean, true);
            } else if (PresentationModel.PROPERTYNAME_AFTER_BEAN.equals(propertyName)) {
                PresentationModel.this.afterBeanChange(oldBean, newBean);
            }
        }
    }

    private static class WrappedBuffer {
        private final BufferedValueModel buffer;
        private final String getterName;
        private final String setterName;

        WrappedBuffer(BufferedValueModel buffer, String getterName, String setterName) {
            this.buffer = buffer;
            this.getterName = getterName;
            this.setterName = setterName;
        }
    }
}

