/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.adapter.DocumentAdapter;
import com.jgoodies.binding.adapter.RadioButtonAdapter;
import com.jgoodies.binding.adapter.SingleListSelectionAdapter;
import com.jgoodies.binding.adapter.ToggleButtonAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ValueModel;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public final class Bindings {
    private static final FocusLostHandler FOCUS_LOST_HANDLER = new FocusLostHandler();
    private static final WeakTrigger FOCUS_LOST_TRIGGER = new WeakTrigger();

    private Bindings() {
    }

    public static void bind(JCheckBox checkBox, ValueModel valueModel) {
        boolean enabled = checkBox.getModel().isEnabled();
        checkBox.setModel(new ToggleButtonAdapter(valueModel));
        checkBox.setEnabled(enabled);
    }

    public static void bind(JCheckBoxMenuItem checkBoxMenuItem, ValueModel valueModel) {
        boolean enabled = checkBoxMenuItem.getModel().isEnabled();
        checkBoxMenuItem.setModel(new ToggleButtonAdapter(valueModel));
        checkBoxMenuItem.setEnabled(enabled);
    }

    public static void bind(JComboBox comboBox, SelectionInList selectionInList) {
        if (selectionInList == null) {
            throw new NullPointerException("The SelectionInList must not be null.");
        }
        comboBox.setModel(new ComboBoxAdapter(selectionInList));
    }

    public static void bind(JFormattedTextField textField, ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        PropertyConnector connector = new PropertyConnector(valueModel, "value", textField, "value");
        connector.updateProperty2();
    }

    public static void bind(JLabel label, ValueModel valueModel) {
        PropertyConnector connector = new PropertyConnector(valueModel, "value", label, "text");
        connector.updateProperty2();
    }

    public static void bind(JList list, SelectionInList selectionInList) {
        if (selectionInList == null) {
            throw new NullPointerException("The SelectionInList must not be null.");
        }
        list.setModel(selectionInList);
        list.setSelectionModel(new SingleListSelectionAdapter(selectionInList.getSelectionIndexHolder()));
    }

    public static void bind(JRadioButton radioButton, ValueModel model, Object choice) {
        boolean enabled = radioButton.getModel().isEnabled();
        radioButton.setModel(new RadioButtonAdapter(model, choice));
        radioButton.setEnabled(enabled);
    }

    public static void bind(JRadioButtonMenuItem radioButtonMenuItem, ValueModel model, Object choice) {
        boolean enabled = radioButtonMenuItem.getModel().isEnabled();
        radioButtonMenuItem.setModel(new RadioButtonAdapter(model, choice));
        radioButtonMenuItem.setEnabled(enabled);
    }

    public static void bind(JTextComponent textComponent, ValueModel valueModel) {
        Bindings.bind(textComponent, valueModel, false);
    }

    public static void bind(JTextComponent textComponent, ValueModel valueModel, boolean commitOnFocusLost) {
        Bindings.bind(textComponent, valueModel, new PlainDocument(), commitOnFocusLost);
    }

    public static void bind(JTextComponent textComponent, ValueModel valueModel, Document document, boolean commitOnFocusLost) {
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        ValueModel textModel = commitOnFocusLost ? Bindings.createCommitOnFocusLostModel(valueModel, textComponent) : valueModel;
        boolean filterNewlines = textComponent instanceof JTextField;
        textComponent.setDocument(new DocumentAdapter(textModel, document, filterNewlines));
    }

    private static ValueModel createCommitOnFocusLostModel(ValueModel valueModel, Component component) {
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        BufferedValueModel model = new BufferedValueModel(valueModel, FOCUS_LOST_TRIGGER);
        component.addFocusListener(FOCUS_LOST_HANDLER);
        return model;
    }

    private static final class WeakPropertyChangeSupport
    extends PropertyChangeSupport {
        private static final ReferenceQueue QUEUE = new ReferenceQueue();

        WeakPropertyChangeSupport(Object sourceBean) {
            super(sourceBean);
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            if (listener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
                this.addPropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
            } else {
                super.addPropertyChangeListener(new WeakPropertyChangeListener(listener));
            }
        }

        public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            super.addPropertyChangeListener(propertyName, new WeakPropertyChangeListener(propertyName, listener));
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            if (listener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
                this.removePropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
                return;
            }
            PropertyChangeListener[] listeners = this.getPropertyChangeListeners();
            for (int i = listeners.length - 1; i >= 0; --i) {
                WeakPropertyChangeListener wpcl;
                if (listeners[i] instanceof PropertyChangeListenerProxy || (wpcl = (WeakPropertyChangeListener)listeners[i]).get() != listener) continue;
                super.removePropertyChangeListener(wpcl);
                break;
            }
        }

        public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            PropertyChangeListener[] listeners = this.getPropertyChangeListeners(propertyName);
            for (int i = listeners.length - 1; i >= 0; --i) {
                WeakPropertyChangeListener wpcl = (WeakPropertyChangeListener)listeners[i];
                if (wpcl.get() != listener) continue;
                super.removePropertyChangeListener(propertyName, wpcl);
                break;
            }
        }

        public void firePropertyChange(PropertyChangeEvent evt) {
            WeakPropertyChangeSupport.cleanUp();
            super.firePropertyChange(evt);
        }

        public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            WeakPropertyChangeSupport.cleanUp();
            super.firePropertyChange(propertyName, oldValue, newValue);
        }

        private static void cleanUp() {
            WeakPropertyChangeListener wpcl;
            while ((wpcl = (WeakPropertyChangeListener)QUEUE.poll()) != null) {
                wpcl.removeListener();
            }
        }

        void removeWeakPropertyChangeListener(WeakPropertyChangeListener l) {
            if (l.propertyName == null) {
                super.removePropertyChangeListener(l);
            } else {
                super.removePropertyChangeListener(l.propertyName, l);
            }
        }

        private final class WeakPropertyChangeListener
        extends WeakReference
        implements PropertyChangeListener {
            final String propertyName;

            private WeakPropertyChangeListener(PropertyChangeListener delegate) {
                this(null, delegate);
            }

            private WeakPropertyChangeListener(String propertyName, PropertyChangeListener delegate) {
                super(delegate, QUEUE);
                this.propertyName = propertyName;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                PropertyChangeListener delegate = (PropertyChangeListener)this.get();
                if (delegate != null) {
                    delegate.propertyChange(evt);
                }
            }

            private void removeListener() {
                WeakPropertyChangeSupport.this.removeWeakPropertyChangeListener(this);
            }
        }
    }

    private static final class WeakTrigger
    implements ValueModel {
        private final transient WeakPropertyChangeSupport changeSupport = new WeakPropertyChangeSupport(this);
        private Boolean value = null;

        WeakTrigger() {
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object newValue) {
            if (newValue != null && !(newValue instanceof Boolean)) {
                throw new IllegalArgumentException("Trigger values must be of type Boolean.");
            }
            Boolean oldValue = this.value;
            this.value = (Boolean)newValue;
            this.fireValueChange(oldValue, newValue);
        }

        public void addValueChangeListener(PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            this.changeSupport.addPropertyChangeListener("value", listener);
        }

        public void removeValueChangeListener(PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            this.changeSupport.removePropertyChangeListener("value", listener);
        }

        private void fireValueChange(Object oldValue, Object newValue) {
            this.changeSupport.firePropertyChange("value", oldValue, newValue);
        }

        void triggerCommit() {
            if (Boolean.TRUE.equals(this.getValue())) {
                this.setValue(null);
            }
            this.setValue(Boolean.TRUE);
        }
    }

    private static class FocusLostHandler
    extends FocusAdapter {
        private FocusLostHandler() {
        }

        public void focusLost(FocusEvent evt) {
            if (!evt.isTemporary()) {
                FOCUS_LOST_TRIGGER.triggerCommit();
            }
        }
    }
}

