/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation;

import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationMessage;
import com.jgoodies.validation.message.SimpleValidationMessage;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ValidationResult
implements Serializable {
    public static final ValidationResult EMPTY = new ValidationResult(Collections.EMPTY_LIST);
    private final List messageList;

    public ValidationResult() {
        this(new LinkedList());
    }

    private ValidationResult(List messageList) {
        this.messageList = messageList;
    }

    public void add(ValidationMessage validationMessage) {
        if (validationMessage == null) {
            throw new NullPointerException("The validation message must not be null.");
        }
        this.messageList.add(validationMessage);
    }

    public void addError(String text) {
        if (text == null) {
            throw new NullPointerException("The message text must not be null.");
        }
        this.messageList.add(new SimpleValidationMessage(text, Severity.ERROR));
    }

    public void addWarning(String text) {
        if (text == null) {
            throw new NullPointerException("The message text must not be null.");
        }
        this.messageList.add(new SimpleValidationMessage(text));
    }

    public void addAll(List messages) {
        if (messages == null) {
            throw new NullPointerException("The messages list must not be null.");
        }
        this.messageList.addAll(messages);
    }

    public void addAllFrom(ValidationResult validationResult) {
        if (validationResult == null) {
            throw new NullPointerException("The validation result to add must not be null.");
        }
        this.addAll(validationResult.getMessages());
    }

    public boolean isEmpty() {
        return this.messageList.isEmpty();
    }

    public int size() {
        return this.messageList.size();
    }

    public boolean contains(ValidationMessage message) {
        return this.messageList.contains(message);
    }

    public ValidationResult subResult(int fromIndex, int toIndex) {
        ValidationResult result = new ValidationResult();
        result.addAll(this.messageList.subList(fromIndex, toIndex));
        return result;
    }

    public ValidationResult subResult(Object messageKey) {
        if (messageKey == null) {
            return EMPTY;
        }
        ValidationResult result = new ValidationResult();
        Iterator it = this.messageList.iterator();
        while (it.hasNext()) {
            ValidationMessage message = (ValidationMessage)it.next();
            if (!messageKey.equals(message.key())) continue;
            result.add(message);
        }
        return result;
    }

    public Map keyMap() {
        HashMap<Object, ValidationResult> map = new HashMap<Object, ValidationResult>();
        Iterator it = this.messageList.iterator();
        while (it.hasNext()) {
            ValidationMessage message = (ValidationMessage)it.next();
            Object key = message.key();
            ValidationResult result = (ValidationResult)map.get(key);
            if (result == null) {
                result = new ValidationResult();
                map.put(key, result);
            }
            result.add(message);
        }
        return map;
    }

    public Severity getSeverity() {
        return ValidationResult.getSeverity(this.getMessages());
    }

    public boolean hasMessages() {
        return !this.isEmpty();
    }

    public boolean hasErrors() {
        return ValidationResult.hasSeverity(this.getMessages(), Severity.ERROR);
    }

    public boolean hasWarnings() {
        return ValidationResult.hasSeverity(this.getMessages(), Severity.WARNING);
    }

    public List getMessages() {
        return Collections.unmodifiableList(this.messageList);
    }

    public List getErrors() {
        return ValidationResult.getMessagesWithSeverity(this.getMessages(), Severity.ERROR);
    }

    public List getWarnings() {
        return ValidationResult.getMessagesWithSeverity(this.getMessages(), Severity.WARNING);
    }

    public String getMessagesText() {
        return ValidationResult.getMessagesText(this.getMessages());
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty ValidationResult";
        }
        StringBuffer buffer = new StringBuffer("ValidationResult:");
        Iterator it = this.messageList.iterator();
        while (it.hasNext()) {
            buffer.append("\n\t").append(it.next());
        }
        return buffer.toString();
    }

    private static Severity getSeverity(List messages) {
        if (messages.isEmpty()) {
            return Severity.OK;
        }
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            ValidationMessage message = (ValidationMessage)it.next();
            if (message.severity() != Severity.ERROR) continue;
            return Severity.ERROR;
        }
        return Severity.WARNING;
    }

    private static boolean hasSeverity(List messages, Severity severity) {
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            ValidationMessage message = (ValidationMessage)it.next();
            if (message.severity() != severity) continue;
            return true;
        }
        return false;
    }

    private static List getMessagesWithSeverity(List messages, Severity severity) {
        LinkedList<ValidationMessage> errorMessages = new LinkedList<ValidationMessage>();
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            ValidationMessage message = (ValidationMessage)it.next();
            if (message.severity() != severity) continue;
            errorMessages.add(message);
        }
        return Collections.unmodifiableList(errorMessages);
    }

    private static String getMessagesText(List messages) {
        if (messages.isEmpty()) {
            return "OK";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            ValidationMessage message = (ValidationMessage)it.next();
            if (buffer.length() > 0) {
                buffer.append("\n");
            }
            buffer.append(message.formattedText());
        }
        return buffer.toString();
    }
}

