/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.JGraphLayoutAlgorithm;

public class SpringEmbeddedLayoutAlgorithm
extends JGraphLayoutAlgorithm {
    public static final String SPRING_EMBEDDED_DISP = "SpringEmbeddedDisp";
    public static final String SPRING_EMBEDDED_POS = "SpringEmbeddedPos";

    public String toString() {
        return "Spring Embedded";
    }

    @Override
    public void run(JGraph jgraph, Object[] cells, Object[] cells1) {
        if (cells == null || cells.length < 1) {
            return;
        }
        DefaultGraphModel model = (DefaultGraphModel)jgraph.getModel();
        Object[] roots = cells;
        ArrayList<Object> rootList = new ArrayList<Object>();
        ArrayList<Object> aloneList = null;
        for (int i = 0; i < roots.length; ++i) {
            if (!model.isEdge(roots[i]) && !model.isPort(roots[i])) {
                if (((DefaultPort)model.getChild(roots[i], 0)).getEdges().size() > 0) {
                    rootList.add(roots[i]);
                    continue;
                }
                if (aloneList == null) {
                    aloneList = new ArrayList<Object>();
                }
                aloneList.add(roots[i]);
                continue;
            }
            rootList.add(roots[i]);
        }
        if (!rootList.isEmpty()) {
            roots = rootList.toArray();
            Object[] xcells = jgraph.getDescendants(roots);
            this.layout(jgraph, xcells);
        }
        if (aloneList != null && !aloneList.isEmpty()) {
            roots = aloneList.toArray();
            Object[] xcells = jgraph.getDescendants(roots);
            this.layout(jgraph, xcells);
            for (int i = 0; i < 5 && this.hasOverlap(jgraph, roots); ++i) {
                roots = rootList.toArray();
                xcells = jgraph.getDescendants(roots);
                this.layout(jgraph, xcells);
            }
        }
    }

    private boolean hasOverlap(JGraph graph, Object[] nodes) {
        graph.getGraphLayoutCache().toFront(nodes);
        for (int i = 0; i < nodes.length; ++i) {
            Object behind;
            Rectangle2D bound = GraphConstants.getBounds((Map)graph.getAttributes(nodes[i]));
            if (bound == null || (behind = graph.getNextCellForLocation(nodes[i], bound.getCenterX(), bound.getCenterY())) == nodes[i]) continue;
            return true;
        }
        return false;
    }

    private void layout(JGraph jgraph, Object[] cells) {
        VertexView v;
        GraphLayoutCache mapper = jgraph.getGraphLayoutCache();
        ArrayList<CellView> V = new ArrayList<CellView>();
        ArrayList<CellView> E = new ArrayList<CellView>();
        Rectangle selectionFrame = new Rectangle();
        int maxVertexWidth = 0;
        for (int i = 0; i < cells.length; ++i) {
            CellView cellView = mapper.getMapping(cells[i], false);
            if (cellView instanceof VertexView) {
                int height;
                int width;
                V.add(cellView);
                Rectangle2D rect = cellView.getBounds();
                Rectangle cellViewBounds = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
                if (cellViewBounds.x < selectionFrame.x) {
                    selectionFrame.x = cellViewBounds.x;
                }
                if (cellViewBounds.y < selectionFrame.y) {
                    selectionFrame.y = cellViewBounds.y;
                }
                if ((width = cellViewBounds.x - selectionFrame.x) > selectionFrame.width) {
                    selectionFrame.width = width;
                }
                if (cellViewBounds.width > maxVertexWidth) {
                    maxVertexWidth = cellViewBounds.width;
                }
                if ((height = cellViewBounds.y - selectionFrame.y) > selectionFrame.height) {
                    selectionFrame.height = height;
                }
            }
            if (!(cellView instanceof EdgeView)) continue;
            E.add(cellView);
        }
        if (selectionFrame.width == 0) {
            selectionFrame.width = 3;
        }
        if (selectionFrame.height == 0) {
            selectionFrame.height = 3;
        }
        double W = selectionFrame.getWidth();
        double L = selectionFrame.getHeight();
        double area = W * L;
        Random random = new Random();
        for (int i = 0; i < V.size(); ++i) {
            VertexView cellView = (VertexView)V.get(i);
            int starPointX = random.nextInt(selectionFrame.width);
            int starPointY = random.nextInt(selectionFrame.height);
            Rectangle randomPosition = new Rectangle(starPointX, starPointY, (int)cellView.getBounds().getWidth(), (int)cellView.getBounds().getHeight());
            cellView.getAttributes().put((Object)SPRING_EMBEDDED_POS, (Object)randomPosition);
        }
        double k = Math.sqrt(area / (double)V.size());
        int iterations = 100;
        for (int i = 0; i < iterations; ++i) {
            for (int vCount = 0; vCount < V.size(); ++vCount) {
                v = (VertexView)V.get(vCount);
                Rectangle vPos = (Rectangle)v.getAttributes().get((Object)SPRING_EMBEDDED_POS);
                Rectangle vDisp = new Rectangle(0, 0);
                for (int uCount = 0; uCount < V.size(); ++uCount) {
                    VertexView u = (VertexView)V.get(uCount);
                    if (u == v) continue;
                    Rectangle uPos = (Rectangle)u.getAttributes().get((Object)SPRING_EMBEDDED_POS);
                    Rectangle delta = new Rectangle();
                    delta.x = vPos.x - uPos.x;
                    delta.y = vPos.y - uPos.y;
                    double fr = this.fr(this.norm(delta), k);
                    double deltaNormX = (double)delta.x / this.norm(delta);
                    double dispX = deltaNormX * fr;
                    double deltaNormY = (double)delta.y / this.norm(delta);
                    double dispY = deltaNormY * fr;
                    vDisp.x += (int)dispX;
                    vDisp.y += (int)dispY;
                }
                v.getAttributes().put((Object)SPRING_EMBEDDED_DISP, (Object)vDisp);
            }
            for (int cellCount = 0; cellCount < E.size(); ++cellCount) {
                CellView u;
                CellView v2;
                EdgeView e = (EdgeView)E.get(cellCount);
                if (e.getSource() == null || e.getTarget() == null || e.getSource() == e.getTarget() || (v2 = ((PortView)e.getSource()).getParentView()) == (u = ((PortView)e.getTarget()).getParentView())) continue;
                Rectangle vPos = (Rectangle)v2.getAttributes().get((Object)SPRING_EMBEDDED_POS);
                Rectangle uPos = (Rectangle)u.getAttributes().get((Object)SPRING_EMBEDDED_POS);
                if (vPos == null || uPos == null) continue;
                Rectangle vDisp = (Rectangle)v2.getAttributes().get((Object)SPRING_EMBEDDED_DISP);
                Rectangle uDisp = (Rectangle)u.getAttributes().get((Object)SPRING_EMBEDDED_DISP);
                if (vDisp == null || uDisp == null) continue;
                Rectangle delta = new Rectangle();
                delta.x = vPos.x - uPos.x;
                delta.y = vPos.y - uPos.y;
                double fa = this.fa(this.norm(delta), k);
                double deltaNormX = (double)delta.x / this.norm(delta);
                double deltaNormY = (double)delta.y / this.norm(delta);
                double dispX = deltaNormX * fa;
                double dispY = deltaNormY * fa;
                vDisp.x -= (int)dispX;
                vDisp.y -= (int)dispY;
                uDisp.x += (int)dispX;
                uDisp.y += (int)dispY;
                v2.getAttributes().put((Object)SPRING_EMBEDDED_DISP, (Object)vDisp);
                u.getAttributes().put((Object)SPRING_EMBEDDED_DISP, (Object)uDisp);
            }
            double t = Math.sqrt(W * W + L * L) * ((double)iterations / (double)(i + 1) / (double)iterations);
            for (int vCount = 0; vCount < V.size(); ++vCount) {
                VertexView v3 = (VertexView)V.get(vCount);
                Rectangle vDisp = (Rectangle)v3.getAttributes().get((Object)SPRING_EMBEDDED_DISP);
                Rectangle vPos = (Rectangle)v3.getAttributes().get((Object)SPRING_EMBEDDED_POS);
                double dispNormX = (double)vDisp.x / this.norm(vDisp);
                double minX = Math.min((double)Math.abs(vDisp.x), t);
                double dispNormY = (double)vDisp.y / this.norm(vDisp);
                double minY = Math.min((double)Math.abs(vDisp.y), t);
                vPos.x = (int)((double)vPos.x + dispNormX * minX);
                vPos.y = (int)((double)vPos.y + dispNormY * minY);
                v3.getAttributes().put((Object)SPRING_EMBEDDED_POS, (Object)vPos);
            }
        }
        Rectangle calculatedFrame = new Rectangle();
        for (int vCount = 0; vCount < V.size(); ++vCount) {
            int height;
            int width;
            v = (VertexView)V.get(vCount);
            Rectangle vPos = (Rectangle)v.getAttributes().get((Object)SPRING_EMBEDDED_POS);
            if (vPos.x < calculatedFrame.x) {
                calculatedFrame.x = vPos.x;
            }
            if (vPos.y < calculatedFrame.y) {
                calculatedFrame.y = vPos.y;
            }
            if ((width = vPos.x - calculatedFrame.x) > calculatedFrame.width) {
                calculatedFrame.width = width;
            }
            if ((height = vPos.y - calculatedFrame.y) <= selectionFrame.height) continue;
            calculatedFrame.height = height;
        }
        double streachX = (double)selectionFrame.width / (double)calculatedFrame.width;
        double streachY = (double)selectionFrame.width / (double)calculatedFrame.width;
        int movementX = selectionFrame.x - calculatedFrame.x;
        int movementY = selectionFrame.y - calculatedFrame.y;
        Hashtable<Object, AttributeMap> viewMap = new Hashtable<Object, AttributeMap>();
        Rectangle[] newCoord = new Rectangle[cells.length];
        int maxCoordX = 1;
        int maxCoordY = 1;
        for (int i = 0; i < cells.length; ++i) {
            CellView cellView = mapper.getMapping(cells[i], false);
            if (cellView instanceof VertexView) {
                VertexView view = (VertexView)cellView;
                newCoord[i] = (Rectangle)view.getAttributes().remove((Object)SPRING_EMBEDDED_POS);
                view.getAttributes().remove((Object)SPRING_EMBEDDED_DISP);
                newCoord[i].x = (int)((double)(newCoord[i].x + movementX) * streachX);
                newCoord[i].y = (int)((double)(newCoord[i].y + movementY) * streachY);
                if (newCoord[i].x > maxCoordX) {
                    maxCoordX = newCoord[i].x;
                }
                if (newCoord[i].y > maxCoordY) {
                    maxCoordY = newCoord[i].y;
                }
            }
            if (!(cellView instanceof EdgeView)) continue;
            cellView.update();
        }
        Dimension ds = jgraph.getSize();
        double graphScaleX = 0.8 * ds.getWidth() / (double)maxCoordX;
        double graphScaleY = 0.7 * ds.getHeight() / (double)maxCoordY;
        for (int i = 0; i < cells.length; ++i) {
            CellView cellView = mapper.getMapping(cells[i], false);
            if (!(cellView instanceof VertexView)) continue;
            newCoord[i].x = (int)((double)newCoord[i].x * graphScaleX);
            newCoord[i].y = (int)((double)newCoord[i].y * graphScaleY);
            AttributeMap map = new AttributeMap();
            GraphConstants.setBounds((Map)map, (Rectangle2D)newCoord[i]);
            viewMap.put(cells[i], map);
        }
        jgraph.getGraphLayoutCache().edit(viewMap, null, null, null);
    }

    protected double fa(double x, double k) {
        return x * x / k;
    }

    protected double fr(double x, double k) {
        return k * k / x;
    }

    protected double norm(Rectangle p) {
        double x = p.x;
        double y = p.y;
        return Math.sqrt(x * x + y * y);
    }

    public static void springEmbeddedLayout(DefaultGraphModel model) {
        Object[] cells = DefaultGraphModel.getAll((GraphModel)model);
        JGraph graph = new JGraph((GraphModel)model);
        graph.setSize(600, 800);
        if (cells != null) {
            JGraphLayoutAlgorithm.applyLayout(graph, new SpringEmbeddedLayoutAlgorithm(), cells, null);
        }
    }
}

