/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import org.jgraph.JGraph;
import org.jgraph.algebra.CostFunction;
import org.jgraph.algebra.DefaultCostFunction;
import org.jgraph.algebra.PriorityQueue;
import org.jgraph.algebra.UnionFind;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.layout.JGraphLayoutAlgorithm;

public class JGraphUtilities {
    public static final int ALIGN_LEFT = 2;
    public static final int ALIGN_RIGHT = 4;
    public static final int ALIGN_TOP = 1;
    public static final int ALIGN_BOTTOM = 3;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_MIDDLE = 12;

    public static BufferedImage toImage(JGraph jGraph, Color color, int n) {
        Object[] objectArray = jGraph.getRoots();
        Rectangle2D rectangle2D = jGraph.getCellBounds(objectArray);
        if (rectangle2D != null) {
            jGraph.toScreen(rectangle2D);
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth() + 2 * n, (int)rectangle2D.getHeight() + 2 * n, color != null ? 1 : 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            } else {
                graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
                graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.setComposite(AlphaComposite.SrcOver);
            }
            graphics2D.translate((int)(-rectangle2D.getX() + (double)n), (int)(-rectangle2D.getY() + (double)n));
            boolean bl = jGraph.isDoubleBuffered();
            RepaintManager repaintManager = RepaintManager.currentManager((JComponent)jGraph);
            repaintManager.setDoubleBufferingEnabled(false);
            jGraph.paint((Graphics)graphics2D);
            repaintManager.setDoubleBufferingEnabled(bl);
            return bufferedImage;
        }
        return null;
    }

    public static Object[] getVertices(GraphModel graphModel, Object[] objectArray) {
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                if (graphModel.isPort(objectArray[i]) || graphModel.isEdge(objectArray[i]) || JGraphUtilities.isGroup(graphModel, objectArray[i])) continue;
                arrayList.add(objectArray[i]);
            }
            return arrayList.toArray();
        }
        return null;
    }

    public static Object[] getEdges(GraphModel graphModel) {
        Object[] objectArray = DefaultGraphModel.getAll((GraphModel)graphModel);
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!graphModel.isEdge(objectArray[i])) continue;
                arrayList.add(objectArray[i]);
            }
            return arrayList.toArray();
        }
        return null;
    }

    public static Object[] getEdges(JGraph jGraph, Object[] objectArray) {
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            GraphModel graphModel = jGraph.getModel();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!graphModel.isEdge(objectArray[i])) continue;
                arrayList.add(objectArray[i]);
            }
            return arrayList.toArray();
        }
        return null;
    }

    public static boolean isVertex(JGraph jGraph, Object object) {
        return !jGraph.getModel().isEdge(object) && !jGraph.getModel().isPort(object) && !JGraphUtilities.isGroup(jGraph, object);
    }

    public static boolean isGroup(JGraph jGraph, Object object) {
        CellView cellView = jGraph.getGraphLayoutCache().getMapping(object, false);
        if (cellView != null) {
            return !cellView.isLeaf();
        }
        return false;
    }

    public static boolean isVertex(GraphModel graphModel, Object object) {
        return !graphModel.isEdge(object) && !graphModel.isPort(object) && !JGraphUtilities.isGroup(graphModel, object);
    }

    public static boolean isGroup(GraphModel graphModel, Object object) {
        for (int i = 0; i < graphModel.getChildCount(object); ++i) {
            if (graphModel.isPort(graphModel.getChild(object, i))) continue;
            return true;
        }
        return false;
    }

    public static CostFunction createDefaultCostFunction(JGraph jGraph) {
        return new DefaultCostFunction((CellMapper)jGraph.getGraphLayoutCache());
    }

    public static UnionFind getComponents(GraphModel graphModel) {
        UnionFind unionFind = new UnionFind();
        Object[] objectArray = JGraphUtilities.getVertices(graphModel, DefaultGraphModel.getAll((GraphModel)graphModel));
        for (int i = 0; i < objectArray.length; ++i) {
            unionFind.find(objectArray[i]);
        }
        Object[] objectArray2 = JGraphUtilities.getEdges(graphModel);
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object = DefaultGraphModel.getSourceVertex((GraphModel)graphModel, (Object)objectArray2[i]);
            Object object2 = DefaultGraphModel.getTargetVertex((GraphModel)graphModel, (Object)objectArray2[i]);
            unionFind.union(unionFind.find(object), unionFind.find(object2));
        }
        return unionFind;
    }

    public static Object[] getShortestPath(GraphModel graphModel, Object object, Object object2, CostFunction costFunction, boolean bl) {
        PriorityQueue priorityQueue = new PriorityQueue();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        priorityQueue.setPrio(object, 0.0);
        int n = JGraphUtilities.getVertices(graphModel, DefaultGraphModel.getAll((GraphModel)graphModel)).length;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray;
            double d = priorityQueue.getPrio();
            Object object3 = priorityQueue.pop();
            if (object3 == object2) break;
            Object[] objectArray2 = new Object[]{object3};
            Object[] objectArray3 = objectArray = bl ? DefaultGraphModel.getOutgoingEdges((GraphModel)graphModel, (Object)object3) : DefaultGraphModel.getEdges((GraphModel)graphModel, (Object[])objectArray2).toArray();
            if (objectArray != null) {
                for (int j = 0; j < objectArray.length; ++j) {
                    Object object4 = DefaultGraphModel.getOpposite((GraphModel)graphModel, (Object)objectArray[j], (Object)object3);
                    double d2 = d + (costFunction != null ? costFunction.getCost(objectArray[j]) : 1.0);
                    if (object4 == null || object4 == object3 || !(d2 < priorityQueue.getPrio(object4))) continue;
                    hashtable.put(object4, objectArray[j]);
                    priorityQueue.setPrio(object4, d2);
                }
            }
            if (priorityQueue.isEmpty()) break;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object5 = object2;
        while (object5 != null) {
            arrayList.add(object5);
            Object v = hashtable.get(object5);
            if (v != null) {
                arrayList.add(v);
                object5 = DefaultGraphModel.getOpposite((GraphModel)graphModel, v, (Object)object5);
                continue;
            }
            object5 = null;
        }
        return arrayList.toArray();
    }

    public static Object[] getSpanningTree(JGraph jGraph, CostFunction costFunction) {
        Object object;
        Object object2;
        Object object3;
        if (costFunction == null) {
            costFunction = JGraphUtilities.createDefaultCostFunction(jGraph);
        }
        GraphModel graphModel = jGraph.getModel();
        SortedSet sortedSet = JGraphUtilities.sort(jGraph, JGraphUtilities.getEdges(graphModel), costFunction);
        UnionFind unionFind = new UnionFind();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (!sortedSet.isEmpty()) {
            object3 = sortedSet.first();
            sortedSet.remove(object3);
            object2 = unionFind.find(DefaultGraphModel.getSourceVertex((GraphModel)graphModel, object3));
            object = unionFind.find(DefaultGraphModel.getTargetVertex((GraphModel)graphModel, (Object)object3));
            if (object2 != null && object != null && object2 == object) continue;
            unionFind.union(object2, object);
            hashSet.add(object3);
        }
        object3 = new HashSet();
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            Object object4 = DefaultGraphModel.getSourceVertex((GraphModel)graphModel, object);
            Object object5 = DefaultGraphModel.getTargetVertex((GraphModel)graphModel, object);
            if (object4 != null) {
                ((HashSet)object3).add(object4);
            }
            if (object5 == null) continue;
            ((HashSet)object3).add(object5);
        }
        object = new Object[hashSet.size() + ((HashSet)object3).size()];
        System.arraycopy(hashSet.toArray(), 0, object, 0, hashSet.size());
        System.arraycopy(((HashSet)object3).toArray(), 0, object, hashSet.size(), ((HashSet)object3).size());
        return object;
    }

    public static SortedSet sort(JGraph jGraph, Object[] objectArray, final CostFunction costFunction) {
        TreeSet<Object> treeSet = new TreeSet<Object>(new Comparator(){

            public int compare(Object object, Object object2) {
                Double d = new Double(costFunction.getCost(object));
                Double d2 = new Double(costFunction.getCost(object2));
                return d.compareTo(d2);
            }
        });
        for (int i = 0; i < objectArray.length; ++i) {
            treeSet.add(objectArray[i]);
        }
        return treeSet;
    }

    public static void connect(JGraph jGraph, DefaultGraphCell defaultGraphCell, Object[] objectArray) {
        Object[] objectArray2 = JGraphUtilities.getVertices(jGraph.getModel(), objectArray);
        if (objectArray2 != null && objectArray2.length < 20) {
            ConnectionSet connectionSet = new ConnectionSet();
            for (int i = 0; i < objectArray2.length; ++i) {
                for (int j = i + 1; j < objectArray2.length; ++j) {
                    if (DefaultGraphModel.containsEdgeBetween((GraphModel)jGraph.getModel(), (Object)objectArray2[i], (Object)objectArray2[j])) continue;
                    Object object = defaultGraphCell.clone();
                    Object object2 = jGraph.getModel().getChild(objectArray2[i], 0);
                    Object object3 = jGraph.getModel().getChild(objectArray2[j], 0);
                    connectionSet.connect(object, object2, object3);
                }
            }
            if (!connectionSet.isEmpty()) {
                jGraph.getGraphLayoutCache().insert(connectionSet.getChangedEdges().toArray(), null, connectionSet, null, null);
            }
        } else {
            throw new IllegalArgumentException("Too many cells selected");
        }
    }

    public static void alignCells(JGraph jGraph, Object[] objectArray, int n) {
        Rectangle2D rectangle2D = jGraph.getCellBounds(objectArray);
        GraphLayoutCache graphLayoutCache = jGraph.getGraphLayoutCache();
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < objectArray.length; ++i) {
            CellView cellView = graphLayoutCache.getMapping(objectArray[i], false);
            Rectangle2D rectangle2D2 = GraphConstants.getBounds((Map)cellView.getAllAttributes());
            if (rectangle2D == null || rectangle2D2 == null) continue;
            Hashtable hashtable2 = new Hashtable();
            Rectangle2D rectangle2D3 = JGraphUtilities.align(n, (Rectangle2D)rectangle2D2.clone(), rectangle2D);
            GraphConstants.setBounds(hashtable2, (Rectangle2D)rectangle2D3);
            hashtable.put(cellView.getCell(), hashtable2);
        }
        if (!hashtable.isEmpty()) {
            graphLayoutCache.edit(hashtable, null, null, null);
        }
    }

    public static Rectangle2D align(int n, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        switch (n) {
            case 2: {
                rectangle2D.setFrame(rectangle2D2.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                break;
            }
            case 1: {
                rectangle2D.setFrame(rectangle2D.getX(), rectangle2D2.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                break;
            }
            case 4: {
                rectangle2D.setFrame(rectangle2D2.getX() + rectangle2D2.getWidth() - rectangle2D.getWidth(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                break;
            }
            case 3: {
                rectangle2D.setFrame(rectangle2D.getX(), rectangle2D2.getY() + rectangle2D2.getHeight() - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
                break;
            }
            case 0: {
                double d = rectangle2D2.getWidth() / 2.0;
                rectangle2D.setFrame(rectangle2D2.getX() + d - rectangle2D.getWidth() / 2.0, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                break;
            }
            case 12: {
                double d = rectangle2D2.getHeight() / 2.0;
                rectangle2D.setFrame(rectangle2D.getX(), rectangle2D2.getY() + d - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            }
        }
        return rectangle2D;
    }

    public static void applyLayout(JGraph jGraph, JGraphLayoutAlgorithm jGraphLayoutAlgorithm) {
        Object[] objectArray = jGraph.isSelectionEmpty() ? DefaultGraphModel.getAll((GraphModel)jGraph.getModel()) : jGraph.getSelectionCells();
        JGraphLayoutAlgorithm.applyLayout(jGraph, jGraphLayoutAlgorithm, objectArray, null);
    }
}

