Option Explicit

On Error Resume Next

Const strMgmts = "winmgmts:\\"
Const strNameSpace = "\root\Microsoft\SqlServer\ComputerManagement"
Const wbemFlagReturnImmediately = &H10
Const wbemFlagForwardOnly = &H20

Dim strComputer,strUserName, strPassword, strDomain, strService
Dim objSQLConfigration, objSWbemLocator

If WScript.Arguments.Count<2 Then
    WScript.Echo "Wrong number of arguments."
    WScript.Quit(1)
End If

'arguments: 0=>hostName 1=>serviceName 2=>userName 3=>pwdValue 4=>domainName
strComputer = WScript.Arguments(0)
strService = WScript.Arguments(1)

Set objSWbemLocator = CreateObject("WbemScripting.SWbemLocator")

Select Case WScript.Arguments.Count
    Case 2
        Set objSQLConfigration = GetObject(strMgmts & strComputer & strNameSpace)

    Case 4
        strUserName = WScript.Arguments(2)
        strPassword = WScript.Arguments(3)
        Set objSQLConfigration = objSWbemLocator.ConnectServer(_
                                        strComputer, _
                                        strNameSpace, _
                                        strUserName, _
                                        strPassword)

    Case 5
        strUserName = WScript.Arguments(2)
        strPassword = WScript.Arguments(3)
        strDomain   = WScript.Arguments(4)
        Set objSQLConfigration = objSWbemLocator.ConnectServer(_
                                        strComputer, _
                                        strNameSpace, _
                                        strUserName, _
                                        strPassword, _
                                        "MS_409", _
                                        "NTLMDomain:" + strDomain)

    Case Else
        WScript.Echo "Wrong number of arguments!"
        WScript.Quit(1)
End Select
Call ErrorHandler

Select Case strService
    Case "f_instances" 'fetch all the instances of sql server
        GetInstances
    Case "f_services" 'fetch all the services of sql server installed on specified machine
        GetServices
    Case Else 'get service state
        GetServiceState
End Select

Sub GetInstances()
    Dim arrInstances, objInstance
    Set arrInstances = objSQLConfigration.ExecQuery("SELECT * FROM ServerSettings", "WQL", wbemFlagReturnImmediately + wbemFlagForwardOnly )
    For Each objInstance in arrInstances
        WScript.Echo objInstance.InstanceName
    Next
End Sub

Sub GetServices()
    Dim sqlServices, sqlService
    Set sqlServices = objSQLConfigration.ExecQuery("SELECT * FROM SqlService", "WQL", wbemFlagReturnImmediately + wbemFlagForwardOnly )
    For Each sqlService In sqlServices
        WScript.Echo sqlService.ServiceName & "._." & sqlService.DisplayName & "._." & sqlService.Description
'        WScript.Echo sqlService.DisplayName 
'        WScript.Echo sqlService.Description
    Next
End Sub

Sub GetServiceState()
    ' sqlServices State:
    ' 1=>Stopped, the service is stopped.
    ' 2=>Start Pending,the service is waiting to start.
    ' 3=>Stop Pending, the service is waiting to stop.
    ' 4=>Running, the service is running.
    ' 5=>Continue Pending, the service is waiting to continue.
    ' 6=>Pause Pending, the service is waiting to pause.
    ' 7=>Paused, the service is paused.
    Dim sqlServices,sqlService
    Set sqlServices = objSQLConfigration.ExecQuery("SELECT * FROM SqlService WHERE ServiceName=""" & strService & """", "WQL", wbemFlagReturnImmediately + wbemFlagForwardOnly )
    For Each sqlService In sqlServices
        If strService = sqlService.ServiceName Then
            WScript.Echo sqlService.State
        End If
    Next
End Sub

'Call ErrorHandler

Function ErrorHandler()
    If Err.Number <> vbEmpty Then
        WScript.Echo "Error Number:" & Err.Number & ", Description:" & Err.Description
        WScript.Quit(Err.Number)
    End If
End Function

