'Retrieve a list of all the running services of a computer
'Usage:     cscript //Nologo service.vbs classname propertyname computerName userName password
'or (if no auth required):        cscript //Nologo service.vbs classname propertyname computerName
On Error Resume Next 
Function HandleError
    If Err.Number <> vbEmpty Then
        Wscript.Echo "Error number " & Err.Number & ". Description: " & err.Description
        Wscript.Quit(Err.Number)
    End If
End Function

Set objSWbemLocator = CreateObject("WbemScripting.SWbemLocator")
Select Case WScript.Arguments.Count

  Case 3
    strComputer = Wscript.Arguments(2)
    Set objSWbemServices = objSWbemLocator.ConnectServer(strComputer,  "root\cimv2")
    call HandleError

  Case 4
    strComputer = Wscript.Arguments(2)
    Set objSWbemServices = objSWbemLocator.ConnectServer(strComputer,  "root\cimv2")
    call HandleError

  Case 5
    strComputer = Wscript.Arguments(2)
    strUser = Wscript.Arguments(3)
    strPassword = Wscript.Arguments(4)
    Set objSWbemServices = objSWbemLocator.ConnectServer(strComputer, _
        "root\cimv2", _
         strUser, _
         strPassword, _
         "MS_409", _
         "ntlmdomain:" + "DOMAIN")
    call HandleError

  Case 6
    strComputer = Wscript.Arguments(2)
    strUser = Wscript.Arguments(3)
    strPassword = Wscript.Arguments(4)
    Set objSWbemServices = objSWbemLocator.ConnectServer(strComputer, _
        "root\cimv2", _
         strUser, _
         strPassword, _
         "MS_409", _
         "ntlmdomain:" + Wscript.Arguments(5))
    call HandleError
  Case Else
	WScript.Echo "Error: Wrong number of arguments"
    WScript.Quit(1)

End Select

Set colSwbemObjectSet = _
		objSWbemServices.ExecQuery(  "Select * from " & Wscript.Arguments(0) )
call HandleError

For Each objService in colSwbemObjectSet
  getCase objService, objSWbemServices
Next

Sub getCase( objService, objSWbemServices )
    strType = ""
    Set colObj = objService.Properties_
    Set objClassProperty = colObj.Item( Wscript.Arguments(1) )
    For Each objClassQualifier In objClassProperty.Qualifiers_
        If objClassQualifier.Name = "countertype" Then
            Select Case objClassQualifier.Value
                Case 65536
                    Wscript.Echo objClassProperty.Value
                Case 272696320
                    getFormattedValue3 objService, objClassProperty, objSWbemServices
                Case 65792
                    Wscript.Echo objClassProperty.Value
                Case 272696576
                    getFormattedValue3 objService, objClassProperty, objSWbemServices
                Case 537003008
                    getFormattedValue2 colObj, objClassProperty
                Case 542180608
                    getFormattedValue4 objService, objClassProperty, objSWbemServices
                Case 807666944 'special *******************
                    getFormattedValue6 objService, objClassProperty
                Case 1073874176  'special ********************
                    getFormattedValue5 colObj, objClassProperty, objSWbemServices
                Case Else
                    strType = objClassQualifier.Value
                    Wscript.Echo "Error: special type : " & strType
            End Select
        End If
    Next
End Sub
Sub getFormattedValue2( colObj, objClassProperty )
    Set colValue = colObj.Item( Wscript.Arguments(1) & "_Base" )
    intBaseValue = colValue.Value
    dblActualFreeSpace = (100 * objClassProperty.Value) / intBaseValue
    Wscript.Echo Int(dblActualFreeSpace)
End Sub

Sub getFormattedValue3( objService, objClassProperty, objSWbemServices )
    CounterValue1 = objClassProperty.Value
    TimeValue1 = objService.TimeStamp_PerfTime
    TimeBase = objService.Frequency_PerfTime
    Wscript.Sleep(5000)
    Set colItems = objSWbemServices.ExecQuery( "Select * from " & Wscript.Arguments(0) )
    For Each objItem in colItems
            Set colProp = objItem.Properties_
        Set colObjItem = colProp.Item( Wscript.Arguments(1) )
        CounterValue2 = colObjItem.Value
        TimeValue2 = objItem.TimeStamp_PerfTime
        If TimeValue2 - TimeValue1 = 0 Then
            Wscript.Echo "Error: time interval is 0."
        Else
            intInterrupts = (CounterValue2 - CounterValue1) / _
                ( (TimeValue2 - TimeValue1) / TimeBase)
            Wscript.Echo  Int(intInterrupts)
        End If
    Next
End Sub

Sub getFormattedValue4( objService, objClassProperty, objSWbemServices )
    CounterValue1 = objClassProperty.Value
    TimeValue1 = objService.TimeStamp_Sys100NS
    Wscript.Sleep(5000)
    Set colItems = objSWbemServices.ExecQuery(  "Select * from " & Wscript.Arguments(0) )
    For Each objItem in colItems
            Set colProp = objItem.Properties_
        Set colObjItem = colProp.Item( Wscript.Arguments(1) )
        CounterValue2 = colObjItem.Value
        TimeValue2 = objItem.TimeStamp_Sys100NS
        If TimeValue2 - TimeValue1 = 0 Then
            Wscript.Echo "Error: time interval is 0."
        Else
            intInterrupts = 100 * (CounterValue2 - CounterValue1) / _
                ( (TimeValue2 - TimeValue1) )
            Wscript.Echo intInterrupts & "%"
        End If
    Next
End Sub
Sub getFormattedValue5 ( colObj, objClassProperty, objSWbemServices )
    CounterValue1 = objClassProperty.Value
    Set objClassPropertyBase = colObj.Item(  Wscript.Arguments(1) & "_Base"  )
    BaseValue1 = objClassPropertyBase.Value
    Wscript.Sleep(60000)
    Set colItems = objSWbemServices.ExecQuery(  "Select * from " & Wscript.Arguments(0) )
    For Each objItem in colItems
        Set colProp = objItem.Properties_
        Set colObjItem = colProp.Item( Wscript.Arguments(1) )
        CounterValue2 = colObjItem.Value
        Set colObjItemBase = colProp.Item( Wscript.Arguments(1) & "_Base" )
        BaseValue2 = colObjItemBase.Value
        If BaseValue2 - BaseValue1 = 0 Then
            Wscript.Echo "Error: BaseValue is 0, CounterType is 1073874176."
        Else
            intInterrupts = (CounterValue2 - CounterValue1) / _
                ( (BaseValue2 - BaseValue1) )
            Wscript.Echo intInterrupts
        End If
    Next
End Sub
Sub	getFormattedValue6 ( objService, objClassProperty )
    startTime = objClassProperty.Value
    currentTime = objService.Timestamp_Object
    If currentTime - startTime > 0 Then
            Wscript.Echo currentTime - startTime
    Else
            Wscript.Echo "Error: currentTime - startTime < 0, CounterType is 807666944"
    End If
End Sub

